% 1. GENERATE PROPER FOLDER STRUCTURE (or pick existing one).
root_path         = 'D:\WORK\PapiersNico\Chapter Pelegri\DivPredProg_publication\DPP package\TEST_NICO_122017';
shape_paths       = f1_generate_paths(root_path);



% 2. PREPARE SOURCE FILEs FOR SHAPES
% Put the source files into the folder "...\your_cell\shapes\source"
% There are different ways to generate a shape source file:
% 1. From experimental stacks   (source file is an 8-bit TIF stack).
% 2. From Surface evolver       (source file is a Surface Evolver-formatted file; "*.txt" or "*.fe").
% 3. From Blender               (source file is a Surface Evolver-formatted file; "*.txt" or "*.fe").
% Procedures for generation are all described in corresponding documents in
% the folder "1_generate_DPP_shapes".


% 3. FIND SHAPES (BODIES) AND LABEL THEM
f2_extract_bodies_from_SE(shape_paths, [160, 160]);              % from Surface Evolver. 2nd Argument: size of the output image, pixels, [x,y].
f2_extract_bodies_from_IJ(shape_paths);                          % from ImageJ. Size is that of the original segmentation of experimental stack.


% 4. VIEW THE RESULTING LABELING
f3_show_labeled_bodies(shape_paths)


% 5. WHAT NEXT? When Bodies have been labeled:
%   - A cell or a set of cells can already be generated from labeled bodies
%   - Polarity input is optional (when a cell is being generated)
%   - MT spatial stability is optional (when a cell is being genereated)
%	- Whe cells are generated, simulations can be started.





